--Test IF there is more than one record THEN DELETE and COMMIT, Else ROLLBACK
--Delete the record with the Maximum cust_id
DECLARE @NbrRows AS INTEGER
DECLARE @Max_id AS INTEGER
BEGIN TRANSACTION			--commence the transaction block
SAVE TRANSACTION Trans_1	--establish a Savepoint for the ROLLBACK
SELECT @Max_id = MAX(cust_id), @NbrRows = COUNT(*)
FROM CustNew
IF @NbrRows>1
BEGIN		
	DELETE
	FROM CustNew
	WHERE cust_id = @Max_id	
COMMIT TRANSACTION
END
ELSE
--apply an 'UNDO' to the transaction if there is more than 1 row
BEGIN
	ROLLBACK TRANSACTION Trans_1
	COMMIT TRANSACTION
END
--Select all rows from the CustNew table
SELECT *
FROM CustNew
ORDER BY cust_id